<?php declare(strict_types=1);

(static function (): void {
    /** @var array<string, string> $functions */
    $functions = [];
    $functions['Xml\Dom\Assert\assert_attribute'] =  __DIR__.'/Xml/Dom/Assert/assert_attribute.php';
    $functions['Xml\Dom\Assert\assert_cdata'] =  __DIR__.'/Xml/Dom/Assert/assert_cdata.php';
    $functions['Xml\Dom\Assert\assert_document'] =  __DIR__.'/Xml/Dom/Assert/assert_document.php';
    $functions['Xml\Dom\Assert\assert_dom_node_list'] =  __DIR__.'/Xml/Dom/Assert/assert_dom_node_list.php';
    $functions['Xml\Dom\Assert\assert_element'] =  __DIR__.'/Xml/Dom/Assert/assert_element.php';
    $functions['Xml\Dom\Builder\attribute'] =  __DIR__.'/Xml/Dom/Builder/attribute.php';
    $functions['Xml\Dom\Builder\attributes'] =  __DIR__.'/Xml/Dom/Builder/attributes.php';
    $functions['Xml\Dom\Builder\cdata'] =  __DIR__.'/Xml/Dom/Builder/cdata.php';
    $functions['Xml\Dom\Builder\children'] =  __DIR__.'/Xml/Dom/Builder/children.php';
    $functions['Xml\Dom\Builder\element'] =  __DIR__.'/Xml/Dom/Builder/element.php';
    $functions['Xml\Dom\Builder\escaped_value'] =  __DIR__.'/Xml/Dom/Builder/escaped_value.php';
    $functions['Xml\Dom\Builder\namespaced_attribute'] =  __DIR__.'/Xml/Dom/Builder/namespaced_attribute.php';
    $functions['Xml\Dom\Builder\namespaced_attributes'] =  __DIR__.'/Xml/Dom/Builder/namespaced_attributes.php';
    $functions['Xml\Dom\Builder\namespaced_element'] =  __DIR__.'/Xml/Dom/Builder/namespaced_element.php';
    $functions['Xml\Dom\Builder\nodes'] =  __DIR__.'/Xml/Dom/Builder/nodes.php';
    $functions['Xml\Dom\Builder\value'] =  __DIR__.'/Xml/Dom/Builder/value.php';
    $functions['Xml\Dom\Builder\xmlns_attribute'] =  __DIR__.'/Xml/Dom/Builder/xmlns_attribute.php';
    $functions['Xml\Dom\Builder\xmlns_attributes'] =  __DIR__.'/Xml/Dom/Builder/xmlns_attributes.php';
    $functions['Xml\Dom\Configurator\canonicalize'] =  __DIR__.'/Xml/Dom/Configurator/canonicalize.php';
    $functions['Xml\Dom\Configurator\comparable'] =  __DIR__.'/Xml/Dom/Configurator/comparable.php';
    $functions['Xml\Dom\Configurator\document_uri'] =  __DIR__.'/Xml/Dom/Configurator/document_uri.php';
    $functions['Xml\Dom\Configurator\loader'] =  __DIR__.'/Xml/Dom/Configurator/loader.php';
    $functions['Xml\Dom\Configurator\normalize'] =  __DIR__.'/Xml/Dom/Configurator/normalize.php';
    $functions['Xml\Dom\Configurator\optimize_namespaces'] =  __DIR__.'/Xml/Dom/Configurator/optimize_namespaces.php';
    $functions['Xml\Dom\Configurator\pretty_print'] =  __DIR__.'/Xml/Dom/Configurator/pretty_print.php';
    $functions['Xml\Dom\Configurator\traverse'] =  __DIR__.'/Xml/Dom/Configurator/traverse.php';
    $functions['Xml\Dom\Configurator\trim_spaces'] =  __DIR__.'/Xml/Dom/Configurator/trim_spaces.php';
    $functions['Xml\Dom\Configurator\utf8'] =  __DIR__.'/Xml/Dom/Configurator/utf8.php';
    $functions['Xml\Dom\Configurator\validator'] =  __DIR__.'/Xml/Dom/Configurator/validator.php';
    $functions['Xml\Dom\Loader\load'] =  __DIR__.'/Xml/Dom/Loader/load.php';
    $functions['Xml\Dom\Loader\xml_file_loader'] =  __DIR__.'/Xml/Dom/Loader/xml_file_loader.php';
    $functions['Xml\Dom\Loader\xml_node_loader'] =  __DIR__.'/Xml/Dom/Loader/xml_node_loader.php';
    $functions['Xml\Dom\Loader\xml_string_loader'] =  __DIR__.'/Xml/Dom/Loader/xml_string_loader.php';
    $functions['Xml\Dom\Locator\Attribute\attributes_list'] =  __DIR__.'/Xml/Dom/Locator/Attribute/attributes_list.php';
    $functions['Xml\Dom\Locator\Attribute\xmlns_attributes_list'] =  __DIR__.'/Xml/Dom/Locator/Attribute/xmlns_attributes_list.php';
    $functions['Xml\Dom\Locator\Element\ancestors'] =  __DIR__.'/Xml/Dom/Locator/Element/ancestors.php';
    $functions['Xml\Dom\Locator\Element\children'] =  __DIR__.'/Xml/Dom/Locator/Element/children.php';
    $functions['Xml\Dom\Locator\Element\locate_by_namespaced_tag_name'] =  __DIR__.'/Xml/Dom/Locator/Element/locate_by_namespaced_tag_name.php';
    $functions['Xml\Dom\Locator\Element\locate_by_tag_name'] =  __DIR__.'/Xml/Dom/Locator/Element/locate_by_tag_name.php';
    $functions['Xml\Dom\Locator\Element\parent_element'] =  __DIR__.'/Xml/Dom/Locator/Element/parent_element.php';
    $functions['Xml\Dom\Locator\Element\siblings'] =  __DIR__.'/Xml/Dom/Locator/Element/siblings.php';
    $functions['Xml\Dom\Locator\Node\children'] =  __DIR__.'/Xml/Dom/Locator/Node/children.php';
    $functions['Xml\Dom\Locator\Node\detect_document'] =  __DIR__.'/Xml/Dom/Locator/Node/detect_document.php';
    $functions['Xml\Dom\Locator\Node\value'] =  __DIR__.'/Xml/Dom/Locator/Node/value.php';
    $functions['Xml\Dom\Locator\Xmlns\linked_namespaces'] =  __DIR__.'/Xml/Dom/Locator/Xmlns/linked_namespaces.php';
    $functions['Xml\Dom\Locator\Xmlns\recursive_linked_namespaces'] =  __DIR__.'/Xml/Dom/Locator/Xmlns/recursive_linked_namespaces.php';
    $functions['Xml\Dom\Locator\Xsd\locate_all_xsd_schemas'] =  __DIR__.'/Xml/Dom/Locator/Xsd/locate_all_xsd_schemas.php';
    $functions['Xml\Dom\Locator\Xsd\locate_namespaced_xsd_schemas'] =  __DIR__.'/Xml/Dom/Locator/Xsd/locate_namespaced_xsd_schemas.php';
    $functions['Xml\Dom\Locator\Xsd\locate_no_namespaced_xsd_schemas'] =  __DIR__.'/Xml/Dom/Locator/Xsd/locate_no_namespaced_xsd_schemas.php';
    $functions['Xml\Dom\Locator\document_element'] =  __DIR__.'/Xml/Dom/Locator/document_element.php';
    $functions['Xml\Dom\Locator\elements_with_namespaced_tagname'] =  __DIR__.'/Xml/Dom/Locator/elements_with_namespaced_tagname.php';
    $functions['Xml\Dom\Locator\elements_with_tagname'] =  __DIR__.'/Xml/Dom/Locator/elements_with_tagname.php';
    $functions['Xml\Dom\Locator\root_namespace'] =  __DIR__.'/Xml/Dom/Locator/root_namespace.php';
    $functions['Xml\Dom\Manipulator\Attribute\rename'] =  __DIR__.'/Xml/Dom/Manipulator/Attribute/rename.php';
    $functions['Xml\Dom\Manipulator\Document\optimize_namespaces'] =  __DIR__.'/Xml/Dom/Manipulator/Document/optimize_namespaces.php';
    $functions['Xml\Dom\Manipulator\Element\copy_named_xmlns_attributes'] =  __DIR__.'/Xml/Dom/Manipulator/Element/copy_named_xmlns_attributes.php';
    $functions['Xml\Dom\Manipulator\Element\rename'] =  __DIR__.'/Xml/Dom/Manipulator/Element/rename.php';
    $functions['Xml\Dom\Manipulator\Node\append_external_node'] =  __DIR__.'/Xml/Dom/Manipulator/Node/append_external_node.php';
    $functions['Xml\Dom\Manipulator\Node\import_node_deeply'] =  __DIR__.'/Xml/Dom/Manipulator/Node/import_node_deeply.php';
    $functions['Xml\Dom\Manipulator\Node\remove'] =  __DIR__.'/Xml/Dom/Manipulator/Node/remove.php';
    $functions['Xml\Dom\Manipulator\Node\remove_namespace'] =  __DIR__.'/Xml/Dom/Manipulator/Node/remove_namespace.php';
    $functions['Xml\Dom\Manipulator\Node\rename'] =  __DIR__.'/Xml/Dom/Manipulator/Node/rename.php';
    $functions['Xml\Dom\Manipulator\Node\replace_by_external_node'] =  __DIR__.'/Xml/Dom/Manipulator/Node/replace_by_external_node.php';
    $functions['Xml\Dom\Manipulator\Node\replace_by_external_nodes'] =  __DIR__.'/Xml/Dom/Manipulator/Node/replace_by_external_nodes.php';
    $functions['Xml\Dom\Manipulator\Xmlns\rename'] =  __DIR__.'/Xml/Dom/Manipulator/Xmlns/rename.php';
    $functions['Xml\Dom\Manipulator\append'] =  __DIR__.'/Xml/Dom/Manipulator/append.php';
    $functions['Xml\Dom\Mapper\xml_string'] =  __DIR__.'/Xml/Dom/Mapper/xml_string.php';
    $functions['Xml\Dom\Mapper\xslt_template'] =  __DIR__.'/Xml/Dom/Mapper/xslt_template.php';
    $functions['Xml\Dom\Predicate\is_attribute'] =  __DIR__.'/Xml/Dom/Predicate/is_attribute.php';
    $functions['Xml\Dom\Predicate\is_cdata'] =  __DIR__.'/Xml/Dom/Predicate/is_cdata.php';
    $functions['Xml\Dom\Predicate\is_default_xmlns_attribute'] =  __DIR__.'/Xml/Dom/Predicate/is_default_xmlns_attribute.php';
    $functions['Xml\Dom\Predicate\is_document'] =  __DIR__.'/Xml/Dom/Predicate/is_document.php';
    $functions['Xml\Dom\Predicate\is_document_element'] =  __DIR__.'/Xml/Dom/Predicate/is_document_element.php';
    $functions['Xml\Dom\Predicate\is_element'] =  __DIR__.'/Xml/Dom/Predicate/is_element.php';
    $functions['Xml\Dom\Predicate\is_non_empty_text'] =  __DIR__.'/Xml/Dom/Predicate/is_non_empty_text.php';
    $functions['Xml\Dom\Predicate\is_text'] =  __DIR__.'/Xml/Dom/Predicate/is_text.php';
    $functions['Xml\Dom\Predicate\is_whitespace'] =  __DIR__.'/Xml/Dom/Predicate/is_whitespace.php';
    $functions['Xml\Dom\Predicate\is_xmlns_attribute'] =  __DIR__.'/Xml/Dom/Predicate/is_xmlns_attribute.php';
    $functions['Xml\Dom\Validator\internal_xsd_validator'] =  __DIR__.'/Xml/Dom/Validator/internal_xsd_validator.php';
    $functions['Xml\Dom\Validator\validator_chain'] =  __DIR__.'/Xml/Dom/Validator/validator_chain.php';
    $functions['Xml\Dom\Validator\xsd_validator'] =  __DIR__.'/Xml/Dom/Validator/xsd_validator.php';
    $functions['Xml\Dom\Xpath\Configurator\all_functions'] =  __DIR__.'/Xml/Dom/Xpath/Configurator/all_functions.php';
    $functions['Xml\Dom\Xpath\Configurator\functions'] =  __DIR__.'/Xml/Dom/Xpath/Configurator/functions.php';
    $functions['Xml\Dom\Xpath\Configurator\namespaces'] =  __DIR__.'/Xml/Dom/Xpath/Configurator/namespaces.php';
    $functions['Xml\Dom\Xpath\Configurator\php_namespace'] =  __DIR__.'/Xml/Dom/Xpath/Configurator/php_namespace.php';
    $functions['Xml\Dom\Xpath\Locator\evaluate'] =  __DIR__.'/Xml/Dom/Xpath/Locator/evaluate.php';
    $functions['Xml\Dom\Xpath\Locator\query'] =  __DIR__.'/Xml/Dom/Xpath/Locator/query.php';
    $functions['Xml\Dom\Xpath\Locator\query_single'] =  __DIR__.'/Xml/Dom/Xpath/Locator/query_single.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\attribute'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/attribute.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\attributes'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/attributes.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\element'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/element.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\group_child_elements'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/group_child_elements.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\grouped_children'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/grouped_children.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\name'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/name.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\namespaces'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/namespaces.php';
    $functions['Xml\Encoding\Internal\Decoder\Builder\unwrap_element'] =  __DIR__.'/Xml/Encoding/Internal/Decoder/Builder/unwrap_element.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\children'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/children.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\element'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/element.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\is_node_list'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/is_node_list.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\normalize_data'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/normalize_data.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\parent_node'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/parent_node.php';
    $functions['Xml\Encoding\Internal\Encoder\Builder\root'] =  __DIR__.'/Xml/Encoding/Internal/Encoder/Builder/root.php';
    $functions['Xml\Encoding\Internal\wrap_exception'] =  __DIR__.'/Xml/Encoding/Internal/wrap_exception.php';
    $functions['Xml\Encoding\document_encode'] =  __DIR__.'/Xml/Encoding/document_encode.php';
    $functions['Xml\Encoding\element_decode'] =  __DIR__.'/Xml/Encoding/element_decode.php';
    $functions['Xml\Encoding\element_encode'] =  __DIR__.'/Xml/Encoding/element_encode.php';
    $functions['Xml\Encoding\typed'] =  __DIR__.'/Xml/Encoding/typed.php';
    $functions['Xml\Encoding\xml_decode'] =  __DIR__.'/Xml/Encoding/xml_decode.php';
    $functions['Xml\Encoding\xml_encode'] =  __DIR__.'/Xml/Encoding/xml_encode.php';
    $functions['Xml\ErrorHandling\Assertion\assert_strict_prefixed_name'] =  __DIR__.'/Xml/ErrorHandling/Assertion/assert_strict_prefixed_name.php';
    $functions['Xml\ErrorHandling\detect_issues'] =  __DIR__.'/Xml/ErrorHandling/detect_issues.php';
    $functions['Xml\ErrorHandling\disallow_issues'] =  __DIR__.'/Xml/ErrorHandling/disallow_issues.php';
    $functions['Xml\ErrorHandling\disallow_libxml_false_returns'] =  __DIR__.'/Xml/ErrorHandling/disallow_libxml_false_returns.php';
    $functions['Xml\ErrorHandling\issue_collection_from_xml_errors'] =  __DIR__.'/Xml/ErrorHandling/issue_collection_from_xml_errors.php';
    $functions['Xml\ErrorHandling\issue_from_xml_error'] =  __DIR__.'/Xml/ErrorHandling/issue_from_xml_error.php';
    $functions['Xml\ErrorHandling\issue_level_from_xml_error'] =  __DIR__.'/Xml/ErrorHandling/issue_level_from_xml_error.php';
    $functions['Xml\ErrorHandling\stop_on_first_issue'] =  __DIR__.'/Xml/ErrorHandling/stop_on_first_issue.php';
    $functions['Xml\Internal\configure'] =  __DIR__.'/Xml/Internal/configure.php';
    $functions['Xml\Reader\Configurator\parser_options'] =  __DIR__.'/Xml/Reader/Configurator/parser_options.php';
    $functions['Xml\Reader\Configurator\substitute_entities'] =  __DIR__.'/Xml/Reader/Configurator/substitute_entities.php';
    $functions['Xml\Reader\Configurator\xsd_schema'] =  __DIR__.'/Xml/Reader/Configurator/xsd_schema.php';
    $functions['Xml\Reader\Loader\xml_file_loader'] =  __DIR__.'/Xml/Reader/Loader/xml_file_loader.php';
    $functions['Xml\Reader\Loader\xml_string_loader'] =  __DIR__.'/Xml/Reader/Loader/xml_string_loader.php';
    $functions['Xml\Reader\Matcher\all'] =  __DIR__.'/Xml/Reader/Matcher/all.php';
    $functions['Xml\Reader\Matcher\any'] =  __DIR__.'/Xml/Reader/Matcher/any.php';
    $functions['Xml\Reader\Matcher\attribute_local_name'] =  __DIR__.'/Xml/Reader/Matcher/attribute_local_name.php';
    $functions['Xml\Reader\Matcher\attribute_local_value'] =  __DIR__.'/Xml/Reader/Matcher/attribute_local_value.php';
    $functions['Xml\Reader\Matcher\attribute_name'] =  __DIR__.'/Xml/Reader/Matcher/attribute_name.php';
    $functions['Xml\Reader\Matcher\attribute_value'] =  __DIR__.'/Xml/Reader/Matcher/attribute_value.php';
    $functions['Xml\Reader\Matcher\document_element'] =  __DIR__.'/Xml/Reader/Matcher/document_element.php';
    $functions['Xml\Reader\Matcher\element_local_name'] =  __DIR__.'/Xml/Reader/Matcher/element_local_name.php';
    $functions['Xml\Reader\Matcher\element_name'] =  __DIR__.'/Xml/Reader/Matcher/element_name.php';
    $functions['Xml\Reader\Matcher\element_position'] =  __DIR__.'/Xml/Reader/Matcher/element_position.php';
    $functions['Xml\Reader\Matcher\namespaced_attribute'] =  __DIR__.'/Xml/Reader/Matcher/namespaced_attribute.php';
    $functions['Xml\Reader\Matcher\namespaced_attribute_value'] =  __DIR__.'/Xml/Reader/Matcher/namespaced_attribute_value.php';
    $functions['Xml\Reader\Matcher\namespaced_element'] =  __DIR__.'/Xml/Reader/Matcher/namespaced_element.php';
    $functions['Xml\Reader\Matcher\nested'] =  __DIR__.'/Xml/Reader/Matcher/nested.php';
    $functions['Xml\Reader\Matcher\node_attribute'] =  __DIR__.'/Xml/Reader/Matcher/node_attribute.php';
    $functions['Xml\Reader\Matcher\node_name'] =  __DIR__.'/Xml/Reader/Matcher/node_name.php';
    $functions['Xml\Reader\Matcher\not'] =  __DIR__.'/Xml/Reader/Matcher/not.php';
    $functions['Xml\Reader\Matcher\sequence'] =  __DIR__.'/Xml/Reader/Matcher/sequence.php';
    $functions['Xml\Writer\Builder\attribute'] =  __DIR__.'/Xml/Writer/Builder/attribute.php';
    $functions['Xml\Writer\Builder\attributes'] =  __DIR__.'/Xml/Writer/Builder/attributes.php';
    $functions['Xml\Writer\Builder\cdata'] =  __DIR__.'/Xml/Writer/Builder/cdata.php';
    $functions['Xml\Writer\Builder\children'] =  __DIR__.'/Xml/Writer/Builder/children.php';
    $functions['Xml\Writer\Builder\comment'] =  __DIR__.'/Xml/Writer/Builder/comment.php';
    $functions['Xml\Writer\Builder\document'] =  __DIR__.'/Xml/Writer/Builder/document.php';
    $functions['Xml\Writer\Builder\element'] =  __DIR__.'/Xml/Writer/Builder/element.php';
    $functions['Xml\Writer\Builder\namespace_attribute'] =  __DIR__.'/Xml/Writer/Builder/namespace_attribute.php';
    $functions['Xml\Writer\Builder\namespaced_attribute'] =  __DIR__.'/Xml/Writer/Builder/namespaced_attribute.php';
    $functions['Xml\Writer\Builder\namespaced_attributes'] =  __DIR__.'/Xml/Writer/Builder/namespaced_attributes.php';
    $functions['Xml\Writer\Builder\namespaced_element'] =  __DIR__.'/Xml/Writer/Builder/namespaced_element.php';
    $functions['Xml\Writer\Builder\prefixed_attribute'] =  __DIR__.'/Xml/Writer/Builder/prefixed_attribute.php';
    $functions['Xml\Writer\Builder\prefixed_attributes'] =  __DIR__.'/Xml/Writer/Builder/prefixed_attributes.php';
    $functions['Xml\Writer\Builder\prefixed_element'] =  __DIR__.'/Xml/Writer/Builder/prefixed_element.php';
    $functions['Xml\Writer\Builder\raw'] =  __DIR__.'/Xml/Writer/Builder/raw.php';
    $functions['Xml\Writer\Builder\value'] =  __DIR__.'/Xml/Writer/Builder/value.php';
    $functions['Xml\Writer\Configurator\indentation'] =  __DIR__.'/Xml/Writer/Configurator/indentation.php';
    $functions['Xml\Writer\Configurator\open'] =  __DIR__.'/Xml/Writer/Configurator/open.php';
    $functions['Xml\Writer\Mapper\memory_output'] =  __DIR__.'/Xml/Writer/Mapper/memory_output.php';
    $functions['Xml\Writer\Opener\memory_opener'] =  __DIR__.'/Xml/Writer/Opener/memory_opener.php';
    $functions['Xml\Writer\Opener\xml_file_opener'] =  __DIR__.'/Xml/Writer/Opener/xml_file_opener.php';
    $functions['Xml\Xsd\Schema\Manipulator\base_path'] =  __DIR__.'/Xml/Xsd/Schema/Manipulator/base_path.php';
    $functions['Xml\Xsd\Schema\Manipulator\overwrite_with_local_files'] =  __DIR__.'/Xml/Xsd/Schema/Manipulator/overwrite_with_local_files.php';
    $functions['Xml\Xslt\Configurator\all_functions'] =  __DIR__.'/Xml/Xslt/Configurator/all_functions.php';
    $functions['Xml\Xslt\Configurator\functions'] =  __DIR__.'/Xml/Xslt/Configurator/functions.php';
    $functions['Xml\Xslt\Configurator\loader'] =  __DIR__.'/Xml/Xslt/Configurator/loader.php';
    $functions['Xml\Xslt\Configurator\parameters'] =  __DIR__.'/Xml/Xslt/Configurator/parameters.php';
    $functions['Xml\Xslt\Configurator\profiler'] =  __DIR__.'/Xml/Xslt/Configurator/profiler.php';
    $functions['Xml\Xslt\Configurator\security_preferences'] =  __DIR__.'/Xml/Xslt/Configurator/security_preferences.php';
    $functions['Xml\Xslt\Loader\from_template_document'] =  __DIR__.'/Xml/Xslt/Loader/from_template_document.php';
    $functions['Xml\Xslt\Transformer\document_to_string'] =  __DIR__.'/Xml/Xslt/Transformer/document_to_string.php';

    foreach ($functions as $function => $file) {
        if (!\function_exists($function)) {
            require_once $file;
        }
    }
})();
